/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.io;

import java.io.*;

public class FileUtils {
    private FileUtils() {}

    /**
     * Removes the specified file or a directory with all its subdirectories.
     *
     * @param f the file or directory to delete
     */
    public static void deleteRecursively(File f) {
        if (f.isDirectory()) {
            File children[] = f.listFiles();
            if (children == null) return;
            for (int i=0; i<children.length; i++) {
                deleteRecursively(children[i]);
            }
        }
        f.delete();
    }
}
